// PageDeviceIP.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageDeviceIP.h"
#include"DecCtrlClientTypes.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include"NvsInfo.h"
// CPageDeviceIP Ի

IMPLEMENT_DYNAMIC(CPageDeviceIP, CDialog)

CPageDeviceIP::CPageDeviceIP(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageDeviceIP::IDD, pParent)
{
	m_iLogonID = -1;
}

CPageDeviceIP::~CPageDeviceIP()
{
}

void CPageDeviceIP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COM_DEC_NUM, m_cboDecNum);
	DDX_Control(pDX, IDC_COMBO2, m_cboCardNum);
	DDX_Control(pDX, IDC_EDIT1, m_edtIp);
	DDX_Control(pDX, IDC_EDT_SUBMASK, m_edtSubMask);
	DDX_Control(pDX, IDC_EDT_GATEWAY, m_edtGateWay);
	DDX_Control(pDX, IDC_EDT_DNS, m_edtDns);
	DDX_Control(pDX, IDC_EDT_MAC, m_edtMac);
	DDX_Control(pDX, IDC_CHK_ALL, m_chkAll);
	DDX_Control(pDX, IDC_BTN_ALTER, m_btnAlter);
	DDX_Control(pDX, IDC_COMBO_NET_CARD_NUM, m_cboNetCardNum);
}


BEGIN_MESSAGE_MAP(CPageDeviceIP, CDialog)
	ON_BN_CLICKED(IDC_BTN_ALTER, &CPageDeviceIP::OnBnClickedBtnAlter)
	ON_CBN_SELCHANGE(IDC_COMBO2, &CPageDeviceIP::OnCbnSelchangeCombo2)
	ON_CBN_SELCHANGE(IDC_COM_DEC_NUM, &CPageDeviceIP::OnCbnSelchangeComDecNum)
	ON_CBN_SELCHANGE(IDC_COMBO_NET_CARD_NUM, &CPageDeviceIP::OnCbnSelchangeComboNetCardNum)
END_MESSAGE_MAP()


// CPageDeviceIP Ϣ
void CPageDeviceIP::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STC_DEC_NUM, GetText(IDS_DEC_ID));
	SetDlgItemText(IDC_STC_CARD_NUM, GetText(IDS_CARD_ID));
	SetDlgItemText(IDC_STC_IP, GetText(IDS_SETTING_IPADDRESS));
	SetDlgItemText(IDC_STC_SUBMASK, GetText(IDS_SETTING_MASK));
	SetDlgItemText(IDC_STC_DNS, GetText(IDS_SETTING_DNS));
	SetDlgItemText(IDC_STC_GATEWAY, GetText(IDS_SETTING_GATE));
	SetDlgItemText(IDC_CHK_ALL, GetText(IDS_ALTER_ALL));
	SetDlgItemText(IDC_BTN_ALTER, GetText(IDS_ALTER));
}
int CPageDeviceIP::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
	return 0;
}

void CPageDeviceIP::OnBnClickedBtnAlter()
{
	if(m_iLogonID < 0)
	{
		return;
	}
	ClusterIP tClusterIP = {0};
	int iRet = 0;
	tClusterIP.iDevId = m_cboDecNum.GetCurSel();
	tClusterIP.iCardId = m_cboCardNum.GetCurSel();
	tClusterIP.iIndex = m_cboNetCardNum.GetCurSel();
	if(tClusterIP.iCardId < 0 || tClusterIP.iCardId > 1)
	{
		//AfxMessageBox(_T("CARDID ERROR"));
		return;
	}
	tClusterIP.iSize = sizeof(ClusterIP);
	if(m_chkAll.GetCheck() == 1)
	{
		tClusterIP.iType = CHANGEIP_TYPE_ALL;
	}
	else
	{
		tClusterIP.iType = CHANGEIP_TYPE_SINGLE;
	}
	CString cstext;
	GetDlgItemText(IDC_EDIT1,cstext);
	strncpy(tClusterIP.cIP, cstext,sizeof(tClusterIP.cIP) - 1);
	GetDlgItemText(IDC_EDT_GATEWAY, cstext);
	strncpy(tClusterIP.cGateway, cstext,sizeof(tClusterIP.cGateway) - 1);
	GetDlgItemText(IDC_EDT_DNS, cstext);
	strncpy(tClusterIP.cDns, cstext,sizeof(tClusterIP.cDns) - 1);
	GetDlgItemText(IDC_EDT_SUBMASK, cstext);
	strncpy(tClusterIP.cSubMask, cstext,sizeof(tClusterIP.cSubMask) - 1);
	iRet = DEC_ClientSetClusterConfig(m_iLogonID, CLUSTER_IP, &tClusterIP, sizeof(ClusterIP));
}

void CPageDeviceIP::OnCbnSelchangeCombo2()
{
	UpdateIpData();
}


void CPageDeviceIP::OnCbnSelchangeComDecNum()
{
	if(m_iLogonID < 0)
	{
		m_iLogonID = 0;
	}
	ClusterDeviceInfo tClusterDeviceInfo = {0};
	int iResultSize = 0;
	tClusterDeviceInfo.iDevId = m_cboDecNum.GetCurSel();
	DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_DEVICE_INFO, &tClusterDeviceInfo, sizeof(ClusterDeviceInfo), &iResultSize);
	m_cboCardNum.ResetContent();
	for (int i=0; i < tClusterDeviceInfo.iCtrlCardNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboCardNum.AddString(strNo);
	}

	m_cboCardNum.SetCurSel(0);

	UpdateIpData();
}

BOOL CPageDeviceIP::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	if(m_iLogonID < 0)
	{
		m_iLogonID = 0;
	}
	ClusterInfo tClusterInfo = {0};
	int iResultSize = 0;
	DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_CLUSTERINFO, &tClusterInfo, sizeof(ClusterInfo), &iResultSize);
	for (int i=0; i < tClusterInfo.iDevNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboDecNum.AddString(strNo);
	}
	m_cboDecNum.SetCurSel(0);

	for (int i = 0; i < MAX_NET_CARD_COUNT; ++i)
	{
		CString strNo;
		strNo.Format("%d", i);
		m_cboNetCardNum.AddString(strNo);
	}
	m_cboNetCardNum.SetCurSel(0);

	OnCbnSelchangeComDecNum();
	OnCbnSelchangeCombo2();
	OnCbnSelchangeComboNetCardNum();
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CPageDeviceIP::UpdateIpData()
{
	if(m_iLogonID < 0)
	{
		m_iLogonID = 0;
	}
	ClusterIP tClusterIP = {0};
	int iRet = 0;
	int iResultSize = 0;
	tClusterIP.iDevId = m_cboDecNum.GetCurSel();
	tClusterIP.iCardId = m_cboCardNum.GetCurSel();
	tClusterIP.iIndex = m_cboNetCardNum.GetCurSel();
	if(tClusterIP.iCardId < 0 || tClusterIP.iCardId > 1)
	{
		//AfxMessageBox(_T("CARDID ERROR"));
		return;
	}
	tClusterIP.iSize = sizeof(ClusterIP);
	iRet = DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_IP, &tClusterIP, sizeof(ClusterIP), &iResultSize);
	if(0 == iRet)
	{
		CString cstext;
		cstext.Format("%s", tClusterIP.cIP);
		SetDlgItemText(IDC_EDIT1,cstext);
		cstext.Format("%s", tClusterIP.cSubMask);
		SetDlgItemText(IDC_EDT_SUBMASK, cstext);
		cstext.Format("%s", tClusterIP.cGateway);
		SetDlgItemText(IDC_EDT_GATEWAY, cstext);
		cstext.Format("%s", tClusterIP.cDns);
		SetDlgItemText(IDC_EDT_DNS, cstext);
	}

	DecCtrlMac tDecCtrlMac = {0};
	tDecCtrlMac.iSize = sizeof(DecCtrlMac);
	tDecCtrlMac.iDevId = m_cboDecNum.GetCurSel();
	tDecCtrlMac.iCardId = m_cboCardNum.GetCurSel();
	tDecCtrlMac.iNetId = m_cboNetCardNum.GetCurSel();

	iRet = DEC_ClientGetClusterConfig(m_iLogonID,CLUSTER_CTRL_MAC, &tDecCtrlMac, sizeof(DecCtrlMac), &iResultSize);
	if(0 == iRet)
	{
		m_edtMac.SetWindowText(tDecCtrlMac.cPcMac);
	}
	else
	{
		m_edtMac.SetWindowText("");
	}
}

void CPageDeviceIP::OnCbnSelchangeComboNetCardNum()
{
	UpdateIpData();
}
